# Notifications Actions — Contexte, objectifs et périmètre

Ce dossier cadre la « passe 2 » dédiée aux notifications interactives et au système d’actions universel, complémentaire au composant de dialogue headless (passe 1, voir `reports/dialog-orchestrator`).

Objectif principal: permettre aux notifications d’exposer des actions sûres (ex: s’abonner, répondre à un sondage, préférences), tout en fournissant un socle d’actions transverse (réutilisable hors notifications), conforme V4 (auth+CSRF, JSON canonique, mutations via `/api/commands`).

## Pourquoi distinct du dialogue universel
- Les contenus de notifications sont rendus dans une iframe sandboxée + CSP stricte (pas de réseau, pas de same-origin). Un « dialogue universel » embarqué dans l’iframe ne peut pas agir en sécurité.
- Les notifications déclenchent donc des actions via un pont `postMessage` → parent, puis le parent exécute la commande (ou ouvre une modale orchestrée si saisie nécessaire). Le composant de dialogue est utilisé côté parent, pas à l’intérieur de l’iframe.

## Ce que nous livrons (Itération 1)
- Pont actions pour notifications:
  - Shortcodes/balises inside (ex: `[sb:action id="sub"]S’abonner[/sb:action]`) transformés en boutons sûrs (`data-sb-action-id`).
  - Préambule JS minimal dans l’iframe: capture clics → `postMessage` avec `nonce`.
  - Routeur parent: filtre `postMessage` par source+nonce, résout l’action via un manifeste d’actions (JSON), exécute commande NonBoard existante (subscribe/unsubscribe/override) ou ouvre une modale orchestrée si besoin.
- Admin: petite palette pour insérer une action (sélection d’un type + paramètres) générant (1) l’entrée du manifeste et (2) le shortcode à coller dans le HTML.
- Sécurité: sanitize du HTML (strip `<script>`/attributs `on*`), CSP `connect-src 'none'`, sandbox sans same-origin; Auth+CSRF; aucune requête depuis l’iframe.

## Ce que nous livrons (Itération 2)
- Jeton signé `actionToken` (HMAC/TTL) pour actions contextuelles/sensibles (ex: sondage, validation) + handlers côté back.
- Support `OpenDialog(schemaRef)` dans les actions (utilise le dialogue universel côté parent + follow-up `/api/commands`).
- Amélioration de la palette Admin (validation des paramètres, preview).

## Points d’intégration
- Front: `public/assets/packages/ui/notifications-rich.js` (routeur parent, gestion iframes), `public/assets/apps/*` (si appels directs de commandes); orchestrateur headless via `public/assets/packages/ui/dialog.js` (passe 1).
- Back: NonBoardBus pour exécuter les actions existantes (User.SubscribeCategory, etc.); endpoints lecture des notifications enrichies.
- Admin: UI pour configurer le manifeste d’actions et produire les shortcodes.

## Garde-fous
- Auth obligatoire et CSRF sur mutations.
- `postMessage`: accepter uniquement les messages provenant de `contentWindow` iframes connues + `nonce` par iframe.
- Manifeste d’actions côté serveur = source d’autorité; l’`actionId` n’est pas un secret, c’est une clé d’UI; le serveur mappe vers un type d’action whitelisté.
- `actionToken` signé (Itération 2) pour lier action ↔ user ↔ notif ↔ paramètres ↔ TTL.

Consulter `PLAN.md` pour le design détaillé, contrat I/O et phasage, et `PROGRESS.md` pour le suivi.

